/****** OBJECT:  STOREDPROCEDURE [DBO].[P_PDV_VD_IT_META_VENDAS_EXECUTE_ALL]    SCRIPT DATE: 11/07/2013 18:13:23 ******/
IF EXISTS (SELECT
						 *
					 FROM
						 SYS.OBJECTS
					 WHERE
						OBJECT_ID = OBJECT_ID(N'[DBO].[P_PDV_VD_IT_META_VENDAS_EXECUTE_ALL]') AND
						TYPE IN ( N'P', N'PC' ))
	DROP PROCEDURE [DBO].[P_PDV_VD_IT_META_VENDAS_EXECUTE_ALL]

GO
GO
GO
--EXEC P_PDV_VD_IT_META_VENDAS_EXECUTE_ALL 1,2016,5,4,1,33,0,'2018-07-01','2018-07-31'
CREATE PROCEDURE P_PDV_VD_IT_META_VENDAS_EXECUTE_ALL (@CD_EMP             INT,
														@ANO                INT,
														@MES                INT,
														@PERC_CRESCIMENTO   MONEY,
														@CD_USU             INT,
														@PERC_LUCRATIVIDADE MONEY,
														@PERC_DESCONTO      MONEY=0,
														@DT_MES_BASE_INICIO DATETIME=NULL,
														@DT_MES_BASE_FIM    DATETIME = NULL)
WITH ENCRYPTION
AS
		PRINT 'GERACAO DE META DE VENDAS'
		SET NOCOUNT ON

		DECLARE @CD_FILIAL INT
		DECLARE FILIAIS CURSOR FAST_FORWARD FOR
			SELECT
				CD_FILIAL
			FROM
				PRC_FILIAL
			ORDER  BY
				CD_FILIAL

		OPEN FILIAIS

		FETCH NEXT FROM FILIAIS INTO @CD_FILIAL
		WHILE @@FETCH_STATUS = 0
			BEGIN
					PRINT 'FILIAL ' + CONVERT(VARCHAR, @CD_FILIAL)

					EXEC P_PDV_VD_IT_META_VENDAS
												@CD_EMP,
												@CD_FILIAL,
												@ANO,
												@MES,
												@PERC_CRESCIMENTO,
												@CD_USU,
												@PERC_LUCRATIVIDADE,
												@PERC_DESCONTO,
												@DT_MES_BASE_INICIO,
												@DT_MES_BASE_FIM
												
					FETCH NEXT FROM FILIAIS INTO @CD_FILIAL
			END

		PRINT 'CONCLUIDO.'
		CLOSE FILIAIS;
		DEALLOCATE FILIAIS; 
